/* Infant Mortality */		
		
set scheme plottig
use Data/Fig 8.dta, clear
encode iso, gen(iso_num)
xtset iso_num year

keep if year >= 2000
bys iso_num: gen idrate_index = idrate / idrate[14] * 100

twoway  (line idrate_index year if iso == "ARG", lpattern(dash)) || 	///
		(line idrate_index year if iso == "BOL", lpattern(dash)) || 	///
		(line idrate_index year if iso == "BRA", lpattern(dash)) || 	///
		(line idrate_index year if iso == "CHL", lpattern(dash)) || 	///
		(line idrate_index year if iso == "COL", lpattern(dash)) || 	///
		(line idrate_index year if iso == "ECU", lpattern(dash)) || 	///
		(line idrate_index year if iso == "PAN", lpattern(dash))	||	///
		(line idrate_index year if iso == "PER", lpattern(dash))	||	///
		(line idrate_index year if iso == "URY", lpattern(dash))	||	///
		(line idrate_index year if iso == "VEN", lwidth(medthick)),	///
 		legend(label(1 ARG) label(2 BOL) label(3 BRA) 				///
				label(4 CHL) label(5 COL) label(6 ECU)				///
				label(7 PAN) label(8 PER) label(9 URY)				///
				label(10 VEN) position(6) rows(2) cols(5))			///
		xtitle("Año") ytitle("Tasa de Mortalidad Infantil (Índice, 100 = 2013)") ///
		xlab(2000(2)2017) 
		graph export infantmortalityrate_index_ESP.png, replace
